import json
import logging
from cse_image_items.BaseItem import BaseItem
from cse_image_items.DataItem import DataItem
from utils import bytes_to_int, hex_string_to_int


logger = logging.getLogger(__name__)
EXTENSION_JSON = 'layout/extension.json'
CLIENT_SYSTEM_INFO_EXTENSION_JSON = 'layout/client_system_info_extension.json'
SKU_TYPES_JSON = 'layout/sku_types.json'
PCH_TYPES_JSON = 'layout/pch_types.json'
CLIENT_SYSTEM_INFO_EXTENSION_ID = '0xc'
MODULE_SIZE_WITHOUT_HASH = 20

try:
    with open(EXTENSION_JSON) as extension_json:
        extension = json.load(extension_json)
except IOError:
    logger.exception('manifest extension layout file does not exist')
    raise IOError('manifest extension layout file does not exist')


try:
    with open(CLIENT_SYSTEM_INFO_EXTENSION_JSON) as client_system_info_extension_json:
        client_system_info_extension = json.load(client_system_info_extension_json)
except IOError:
    logger.exception('client system info manifest extension layout file does not exist')
    raise IOError('client system info manifest extension layout file does not exist')

try:
    with open(SKU_TYPES_JSON) as sku_types_json:
        sku_types = json.load(sku_types_json)
except IOError:
    logger.info('sku types file does not exist')
    raise IOError('sku types file does not exist')

try:
    with open(PCH_TYPES_JSON) as pch_types_json:
        pch_types = json.load(pch_types_json)
except IOError:
    logger.info('pch types file does not exist')
    raise IOError('pch types file does not exist')


class ManifestExtensionFactory(object):
    @staticmethod
    def create(value, offset):
        logger.info('START ManifestExtensionFactory.create FUNCTION')

        extension_type = hex(bytes_to_int(value[offset:offset + 4]))
        if extension_type == CLIENT_SYSTEM_INFO_EXTENSION_ID:
            return ClientSystemInfoExtensionExtension(data=value, offset=hex(offset).decode())
        return ManifestExtension(data=value, offset=hex(offset).decode())


class ManifestExtension(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START ManifestExtension.__init__ FUNCTION')
        
        extension['offset'] = kwargs['offset']
        super(ManifestExtension, self).__init__(data, **extension)


class ClientSystemInfoExtensionExtension(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START ClientSystemInfoExtensionExtension.__init__ FUNCTION')
        client_system_info_extension['offset'] = kwargs['offset']
        super(ClientSystemInfoExtensionExtension, self).__init__(data, **client_system_info_extension)
        sku_type = DataItem(
            self.value, **client_system_info_extension['FW_SKU_attributes']['firmware_sku'])
        self.sku_type = sku_types[sku_type.hex_value()]
        pch_type = DataItem(
            self.value, **client_system_info_extension['FW_SKU_attributes']['PCH_type'])
        self.pch_type = pch_types[pch_type.hex_value()]